﻿© Fluke Calibration. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Test LIB /8508
DATE:                  2011-10-24 09:27:15
AUTHOR:                Fluke
REVISION:              $Revision: 1.2 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       170
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Text Source:
#    $RCSfile: sub_ni_pxi-4130_1yr_ch1_current_prog_test_lib_8508.txt,v $
#    $Date: 2011/10/24 19:04:32 $
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        PXI-4130
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Subprocedures:
#        Sub NI DC Power Setup LIB
#        Sub NI DC Power Output Off LIB
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         200uA_PROGRAMMING_TEST       PSUBI("200 µA Prog Test")
  1.002  JMPL         2mA_PROGRAMMING_TEST         PSUBI("2 mA Prog Test")
  1.003  JMPL         20mA_PROGRAMMING_TEST        PSUBI("20 mA Prog Test")
  1.004  JMPL         200mA_PROGRAMMING_TEST       PSUBI("200 mA Prog Test")
  1.005  JMPL         2A_PROGRAMMING_TEST          PSUBI("2 A Prog Test")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Test LIB /8508  =============

  2.001  LABEL        200uA_PROGRAMMING_TEST
  2.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-6

  2.003  IF           @niDCPwrVolt < 0
  2.004  MATH         CardinalPoint = -1 * CardinalPoint
  2.005  ENDIF

  2.006  JMPL         START_CH1_200uA_TEST

  2.007  TARGET       -p
  2.008  MATH         @First = 1

  2.009  LABEL        START_CH1_200uA_TEST

  2.010  IF           @First
  2.011  DISP         Connect the UUT to the 8508A as follows:
  2.011  DISP
  2.011  DISP         [32]       UUT           8508A
  2.011  DISP         [32] Channel 1 High ---> INPUT A
  2.011  DISP         [32] Channel 1 Low ----> INPUT LO
  2.012  MATH         @First = 0
  2.013  ENDIF

  2.014  TSET         CPT = [V CardinalPoint] uA; MEAS = SA
  2.015  CALL         Sub NI DC Power Setup LIB
  2.016  WAIT         -t 3 Settling...
  2.017  TARGET       -m
  2.018  MATH         MEM = CardinalPoint
  2.019  8508   200   uA             0.03% 0.100U                    D5    2W

  3.001  END

  3.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Test LIB /8508  ===============

  4.001  LABEL        2mA_PROGRAMMING_TEST
  4.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  4.003  IF           @niDCPwrVolt < 0
  4.004  MATH         CardinalPoint = -1 * CardinalPoint
  4.005  ENDIF

  4.006  TARGET       -p
  4.007  TSET         CPT = [V CardinalPoint] mA; MEAS = SA
  4.008  CALL         Sub NI DC Power Setup LIB
  4.009  WAIT         -t 3 Settling...
  4.010  TARGET       -m
  4.011  MATH         MEM = CardinalPoint
  4.012  8508   2     mA             .03% .00100U                    D5    2W

  5.001  END

  5.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Test LIB /8508  ==============

  6.001  LABEL        20mA_PROGRAMMING_TEST
  6.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  6.003  IF           @niDCPwrVolt < 0
  6.004  MATH         CardinalPoint = -1 * CardinalPoint
  6.005  ENDIF

  6.006  TARGET       -p
  6.007  TSET         CPT = [V CardinalPoint] mA; MEAS = SA
  6.008  CALL         Sub NI DC Power Setup LIB
  6.009  WAIT         -t 3 Settling...
  6.010  TARGET       -m
  6.011  MATH         MEM = CardinalPoint
  6.012  8508   20    mA             0.03% 0.0100U                   D5    2W

  7.001  END

  7.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Test LIB /8508  =============

  8.001  LABEL        200mA_PROGRAMMING_TEST
  8.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  8.003  IF           @niDCPwrVolt < 0
  8.004  MATH         CardinalPoint = -1 * CardinalPoint
  8.005  ENDIF

  8.006  TARGET       -p
  8.007  TSET         CPT = [V CardinalPoint] mA; MEAS = SA
  8.008  CALL         Sub NI DC Power Setup LIB
  8.009  WAIT         -t 3 Settling...
  8.010  TARGET       -m
  8.011  MATH         MEM = CardinalPoint
  8.012  8508   200   mA             0.03% 0.100U                    D5    2W

  9.001  END

  9.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Test LIB /8508  ================

 10.001  LABEL        2A_PROGRAMMING_TEST
 10.002  MATH         CardinalPoint = @niDCPwrCurrLmt

 10.003  IF           @niDCPwrVolt < 0
 10.004  MATH         CardinalPoint = -1 * CardinalPoint
 10.005  ENDIF

 10.006  TARGET       -p
 10.007  TSET         CPT = [V CardinalPoint] A; MEAS = SA
 10.008  CALL         Sub NI DC Power Setup LIB
 10.009  WAIT         -t 3 Settling...
 10.010  TARGET       -m
 10.011  MATH         MEM = CardinalPoint
 10.012  8508   2     A              .12% .00100U                    D6    2W

 11.001  END